/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.plant;

import com.badlogic.gdx.graphics.Color;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import technology.rocketjump.undermount.environment.model.Season;

public class PlantSpeciesFruit {
    private final String fruitName;
    private final List<Season> growingSeasons;
    private final String colorCode;
    @JsonIgnore
    private final Color color;

    @JsonCreator
    public PlantSpeciesFruit(@JsonProperty(value="fruitName") String fruitName, @JsonProperty(value="growingSeasons") List<Season> growingSeasons, @JsonProperty(value="colorCode") String colorCode) {
        this.fruitName = fruitName;
        this.colorCode = colorCode;
        this.growingSeasons = growingSeasons;
        if (colorCode == null) {
            this.color = null;
        } else if (colorCode.trim().length() == 7) {
            colorCode = colorCode.trim();
            this.color = new Color((float)Integer.parseInt(colorCode.substring(1, 3), 16) / 255.0f, (float)Integer.parseInt(colorCode.substring(3, 5), 16) / 255.0f, (float)Integer.parseInt(colorCode.substring(5, 7), 16) / 255.0f, 1.0f);
        } else {
            this.color = null;
            System.err.println("Unrecognised color code " + colorCode + " for " + this.getClass().getName());
        }
    }

    public List<Season> getGrowingSeasons() {
        return this.growingSeasons;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public Color getColor() {
        return this.color;
    }

    public String getFruitName() {
        return this.fruitName;
    }
}

